 ; Ŀ
 ;   FL - flip layer settings from Off or Frozen to On and vice versa.     
 ;   Off and Frozen are considered to be identical.                        
 ;   Copyright 2006 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Cold - see if a layer is On or Off/Frozen.                            
 ;   Argument: Layy, a layer name.                                         
 ;   Returns T if the layer is off or frozen, else nil.                    
 ; 
 (DEFUN COLD (layy / lock off froz layy col stat)
  (setq layy (tblsearch "layer" layy))
  (if (and (setq col (cdr (assoc 62 layy)))
           (minusp col))
      (setq off t))
  (if (and (setq stat (cdr (assoc 70 layy)))
           (= 1 (logand 1 stat)))
      (setq froz t))
  (if (and stat                      ; may be useful later
           (= 4 (logand 4 stat)))
      (setq lock t))
 (or off froz))
 ; Ŀ
 ;   Cold end.                                                             
 ; 

 ; Ŀ
 ;   Fl.                                                                   
 ; 
 (DEFUN C:FL (/ rew layy namm)
  (setvar "cmdecho" 0)
  (setq rew t)
  (while (setq layy (tblnext "layer" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 layy)))
         (if (cold namm)
             (command "layer" "thaw" namm "on" namm "")
             (command "layer" "freeze" namm "")))
 (princ))